<?php get_header(); ?>
<main class="main">

    <div class="mv">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/index/main_pc.jpg" alt="main" class="pc--on">
        <img src="<?php echo get_template_directory_uri(); ?>/assets/img/index/main_sp.jpg" alt="main" class="sp--on">
        <div class="mv__ttl">
            <h2 class="mv__jp">本格コーヒーと手作りスイーツで<br>ゆったりひと息</h2>
            <span class="mv__en">CAFE ASABEN</span>
        </div>
    </div>

    <section class="section index__news">
        <div class="content content--small">
            <div class="ttl__base txt--center fadein">
                <h3 class="ttl__base--jp">お知らせ</h3>
                <span class="ttl__base--en font--en">News</span>
            </div>
            <?php
                $asaben_args = array(
                    'post_type'      => 'post',
                    'posts_per_page' => 3,
                );
                $asabenNews_query = new WP_Query( $asaben_args );
                if ( $asabenNews_query->have_posts() ) :
            ?>
                <ul class="newsList fadein">
                    <?php
                        while ( $asabenNews_query->have_posts() ) :
                        $asabenNews_query->the_post();
                    ?>
                        <?php get_template_part( 'template-parts/loop', 'post' ); ?>
                    <?php
                        endwhile;
                        wp_reset_postdata();
                    ?>
                </ul>
            <?php endif; ?>
            <div class="btn__base txt--center fadein">
                <a href="<?php echo esc_url( home_url()); ?>/news/">お知らせをもっと見る</a>
            </div>
        </div>
    </section>

    <section class="section section--bg index__sweets">
        <div class="content content--large">
            <div class="ttl__base txt--center fadein">
                <h3 class="ttl__base--jp">新作スイーツ</h3>
                <span class="ttl__base--en font--en">Sweets</span>
            </div>
            <?php
                $sweets_args = array(
                    'post_type'      => 'sweets',
                    'posts_per_page' => 4,
                );
                $asabenSweets_query = new WP_Query( $sweets_args );
                if ( $asabenSweets_query->have_posts() ) :
            ?>
                <div class="sweetsList fadein">
                    <?php
                        while ( $asabenSweets_query->have_posts() ) :
                        $asabenSweets_query->the_post();
                    ?>
                    <a href="<?php the_permalink(); ?>" class="sweetsList__item">
                        <?php get_template_part( 'template-parts/loop', 'sweets' ); ?>
                    </a>
                    <?php
                        endwhile;
                        wp_reset_postdata();
                    ?>
                </div>
            <?php endif; ?>

            <div class="btn__base txt--center fadein">
                <a href="<?php echo esc_url( home_url()); ?>/sweets/">新作スイーツをもっと見る</a>
            </div>
        </div>
    </section>

    <section class="section index__information">
        <div class="content content--large">
            <div class="ttl__base txt--center fadein">
                <h3 class="ttl__base--jp">店舗案内</h3>
                <span class="ttl__base--en font--en">Information</span>
            </div>
            <div class="information__data fadein">
                <dl class="information__item">
                    <dt class="information__ttl">住所</dt>
                    <dd class="information__detail">〒000-0000 長野県上田市中央000</dd>
                </dl>
                <dl class="information__item">
                    <dt class="information__ttl">TEL</dt>
                    <dd class="information__detail">123-456-7890</dd>
                </dl>
                <dl class="information__item">
                    <dt class="information__ttl">営業時間</dt>
                    <dd class="information__detail">平日 8:00〜21:00 / 土日祝 10:00〜22:00</dd>
                </dl>
                <dl class="information__item">
                    <dt class="information__ttl">定休日</dt>
                    <dd class="information__detail">毎週月曜日</dd>
                </dl>
            </div>
            <div class="btn__base txt--center fadein">
                <a href="<?php echo esc_url( home_url()); ?>/information/">店舗案内をもっと見る</a>
            </div>
        </div>
    </section>

</main>
<?php get_footer(); ?>