<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <title>Cafe ASABEN</title>
    <link href="<?php echo get_template_directory_uri(); ?>/assets/css/style.css" rel="stylesheet">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@400;500;700&family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <header class="header">
        <div class="header__inner">
            <a href="<?php echo esc_url( home_url()); ?>/" class="header__logo">
                <h1>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.svg" alt="CAFE ASABEN">
                </h1>
                <span class="header__subTtl">本格コーヒーと手作りスイーツ</span>
            </a>
            <div class="menu">
                <div class="menu__btn">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <nav class="menu__box">
                    <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'main-menu',
                            'menu_class' => 'menu__list',
                            'container' => false,
                            )
                        );
                    ?>
                </nav>
            </div>
        </div>
    </header>