<li class="newsList__item">
    <a href="<?php the_permalink(); ?>" class="newsList__link"></a>
    <div class="newsList__itemInner">
        <div class="newsList__img">
            <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail(); ?>
            <?php else : ?>
            <img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/img/news/thumb_news.jpg" alt="NEWS">
            <?php endif; ?>
        </div>
        <div class="newsList__cont">
            <h3 class="newsList__ttl">
                <?php the_title(); ?>
            </h3>
            <?php the_excerpt(); ?>
            <div class="newsList__data">
                <?php
                $category = get_the_category();
                if (!empty( $category )) :
                ?>
                <?php
                foreach($category as $cat):
                echo '<a class="newsList__cat" href="' . get_category_link( $cat->cat_ID ) . '">' . $cat->cat_name . '</a>';
                endforeach;
                ?>
                <?php endif; ?>
                <p class="newsList__time">
                    <?php echo get_the_date(); ?>
                </p>
            </div>
        </div>
    </div>
</li>